/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.exportacion.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModeloValoresRefrendo
implements ModeloValores {
    private boolean inicializado;
    private UtilCatalogosATS dc = UtilCatalogosATS.crearInstancia();
    private final Map<String, ElementoNombreValor<String>> tiposRefrendo = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> distritos = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> regimenes = new TreeMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposDeIngresoDelExterior = new TreeMap<String, ElementoNombreValor<String>>();
    private boolean regimenEcuapass;
    private static final String DE_SERVICIOS = "03";
    private Periodo periodo;

    public ModeloValoresRefrendo(boolean regimenEcuapass, Periodo periodo) {
        this.regimenEcuapass = regimenEcuapass;
        this.periodo = periodo;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposRefrendo();
            this.cargarDistritos();
            this.cargarRegimenes();
            this.cargarTiposDeIngresoDelExterior();
            this.inicializado = true;
        }
    }

    private void cargarRegimenes() {
        this.regimenes.clear();
        Map catalogo = this.dc.obtenerRegimenesAduaneros(this.regimenEcuapass);
        for (Map.Entry elemento : catalogo.entrySet()) {
            this.regimenes.put((String)elemento.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)elemento.getKey()) + "-" + (String)elemento.getValue(), (Object)((String)elemento.getKey())));
        }
    }

    private void cargarDistritos() {
        this.distritos.clear();
        Map catalogo = this.dc.obtenerDistritosAduaneros();
        for (Map.Entry elemento : catalogo.entrySet()) {
            this.distritos.put((String)elemento.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)elemento.getValue(), (Object)((String)elemento.getKey())));
        }
    }

    private void cargarTiposRefrendo() {
        this.tiposRefrendo.clear();
        Map catalogo = this.dc.obtenerTipoExportaciones();
        for (Map.Entry elemento : catalogo.entrySet()) {
            if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
                this.tiposRefrendo.put((String)elemento.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)elemento.getKey()) + "-" + (String)elemento.getValue(), (Object)((String)elemento.getKey())));
                continue;
            }
            if (((String)elemento.getKey()).equals(DE_SERVICIOS)) continue;
            this.tiposRefrendo.put((String)elemento.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)elemento.getKey()) + "-" + (String)elemento.getValue(), (Object)((String)elemento.getKey())));
        }
    }

    private void cargarTiposDeIngresoDelExterior() {
        this.tiposDeIngresoDelExterior.clear();
        Map catalogo = this.dc.obtenerTiposDeIngresoDelExteriorPorPeriodo(this.periodo.getFechaDeclarada());
        for (Map.Entry elemento : catalogo.entrySet()) {
            this.tiposDeIngresoDelExterior.put((String)elemento.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)elemento.getValue(), (Object)((String)elemento.getKey())));
        }
    }

    public ElementoNombreValor<String> obtenerTipoRefrendo(String tipoRefrendo) {
        return StringUtil.isNullOrEmpty((String)tipoRefrendo) ? null : this.tiposRefrendo.get(tipoRefrendo);
    }

    public ElementoNombreValor<String> obtenerDistrito(String distrito) {
        return StringUtil.isNullOrEmpty((String)distrito) ? null : this.distritos.get(distrito);
    }

    public ElementoNombreValor<String> obtenerRegimen(String regimen) {
        return StringUtil.isNullOrEmpty((String)regimen) ? null : this.regimenes.get(regimen);
    }

    public ElementoNombreValor<String> obtenerTipoIngresoDelExterior(String ingresoDelExterior) {
        return StringUtil.isNullOrEmpty((String)ingresoDelExterior) ? null : this.tiposDeIngresoDelExterior.get(ingresoDelExterior);
    }

    public List<ElementoNombreValor<String>> getTiposRefrendo() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposRefrendo.values());
    }

    public List<ElementoNombreValor<String>> getDistritos() {
        return new ArrayList<ElementoNombreValor<String>>(this.distritos.values());
    }

    public List<ElementoNombreValor<String>> getRegimenes() {
        return new ArrayList<ElementoNombreValor<String>>(this.regimenes.values());
    }

    public List<ElementoNombreValor<String>> getTiposDeIngresoDelExterior() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeIngresoDelExterior.values());
    }
}

